/************************************************************************************************
 *   深圳市摩西尔电子有限公司 @版本所有@
 *
 *   此文件用于获取寄存器项相关数据
 *
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 徐烁超
 *      时间 : 2019.12.03
 *      内容 : 所有代码
 *************************************************************************************************/
/* exported mc_reg_merge_box */

/* global mc_get_top_fun */
/* global g_str_box_name */
/* global mc_main_updata_screen_data_box_name */
/* global g_str_ctrlchip */
/* global g_str_dispchip */
/* global g_str_scanchip */
/* global g_obj_dischip_data_merge */
/* global g_obj_scanchip_data_merge */
/* global g_str_dischip_end */
/* global g_str_scanchip_end */
/* global g_str_dischip_data */
/* global g_str_scanchip_data */
/* global g_str_dischip_data_advance */
/* global g_str_scanchip_data_advance */
/* global mc_sdk_get_reg */
/* global mc_sdk_get_reg_list */
/* global mc_main_send_place */
/* global mc_sdk_param */
/* global mc_crypto_set_box_md5_to_key */
/* global mc_main_get_idx_by_name */
/* global mc_ui_box */
/* global $ */
/* global mc_ui_item_grp */

var JSON_ATTR_ID_UI_TYPE = "UI_TYPE";
var JSON_ATTR_ID_VAL_TYPE = "VAL_TYPE";
var JSON_ATTR_ID_CTRLCHIP = "CTRLCHIP";

var JSON_TYPE_VALUE_EDIT = "EDIT";
var JSON_TYPE_VALUE_HEX = "hex";

var JSON_PAPRAM_GET = "GET_PARAM";
var JSON_PAPRAM_SET = "SET_PARAM";

var JSON_FUN_DISPCHIP_REG_ITEM = "DISPCHIP_REG_ITEM";
var JSON_FUN_SCANCHIP_REG_ITEM = "SCANCHIP_REG_ITEM";
var JSON_FUN_SCANCHIP_REG_ITEM_LANG = "SCANCHIP_REG_ITEM_LANG";
var JSON_FUN_DISPCHIP_REG_ITEM_LANG = "DISPCHIP_REG_ITEM_LANG";
var JSON_FUN_DISPCHIP_REG_LIST = "DISPCHIP_REG_LIST";
var JSON_FUN_SCANCHIP_REG_LIST = "SCANCHIP_REG_LIST";

var g_str_merge_box_name = "";

// 控件类型
var G_ARR_UI_TYPE = new mc_ui_item_grp().get_ui_type();


/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    字符串截取
 * 参数:
 *    @param {Promise<string>} str_param 处理参数
 *    @param {Promise<string>} str_way 处理方式
 *    @param {Promise<number>} ui_idx 需要输出的下标
 * 返回：
 *    @returns {Promise<Array>} 处理截取成功的数组,否则为空;
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 徐烁超
 *      时间 : 2019.11.21
 *      内容 : 所有代码
 ************************************************************************************************/
function mc_reg_splice_str(str_param, str_way, ui_idx) {
    if ("string" !== typeof str_param || 0 >= str_param.length) {
        return [];
    }
    if (-1 === str_param.indexOf(str_way)) {
        return [str_param];
    }
    var str_param_res = str_param.split(str_way);

    if ("number" !== typeof ui_idx) {
        return str_param_res;
    }
    if (str_param_res.length <= ui_idx || 0 > ui_idx) {
        return str_param_res;
    }
    return str_param_res[ui_idx];
}

//rcstt = reconsitution
/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    寄存器项更新
 * 参数:
 *    @param {Promise<object>} obj_reg_data 请求寄存器信息
 *          {str_ctrlchip:<string>,(主控芯片名称 *不允许为空)
 *           str_chip_name:<string>,(查询芯片名称 *不允许为空)
 *           b_chipname_type:<boolean>,(查询芯片标识(true/false = 显示/行管) *不允许为空)
 *           str_end_name:<string>,(最后一次操作的属性名)
 *           obj_pamt_merge:<object>,(合并参数表)
 *           obj_ui_json:<object>}(页面/发送字串)
 *    @param {Promise<function>} fun_callback 传入回调函数,不能为空(ui_json对象,合并参数表,更新与否的布尔值)
 *    @param {Promise<Boolean>} b_is_default 获取常规模式
 * 返回：
 *    NA
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 徐烁超
 *      时间 : 2019.12.03
 *      内容 : 所有代码
 ************************************************************************************************/
function mc_reg_update_from_sdk(obj_reg_data, fun_callback, b_is_default) {
    if ("function" !== typeof fun_callback) {
        return;
    }
    var str_ctrlchip = obj_reg_data.str_ctrlchip;
    var str_chip_name = obj_reg_data.str_chip_name;
    var b_chipname_type = obj_reg_data.b_chipname_type;
    var str_end_name = obj_reg_data.str_end_name;
    var obj_ui_merge = obj_reg_data.obj_pamt_merge;

    if ("string" !== typeof str_ctrlchip || 0 >= str_ctrlchip.length) {
        fun_callback();
        return;
    }
    if ("string" !== typeof str_chip_name || 0 >= str_chip_name.length) {
        fun_callback();
        return;
    }
    if ("boolean" !== typeof b_chipname_type) {
        fun_callback();
        return;
    }
    var str_ui_json = obj_reg_data.obj_ui_json;

    if ("string" !== typeof str_ui_json) {
        str_ui_json = JSON.stringify(str_ui_json);
    }
    var obj_ui_param = new mc_sdk_param();

    obj_ui_param.set_json(str_ui_json);
    var ui_param_cnt_from_ui = obj_ui_param.get_param_cnt();
    var str_item_json = "";

    if (0 < ui_param_cnt_from_ui) {
        str_item_json = mc_reg_tran_ui_to_item(obj_ui_param, obj_ui_merge, str_end_name);
    }
    if (b_is_default) {
        get_reg_msg();
    } else {
        mc_reg_language_suf(str_ctrlchip, str_chip_name, b_chipname_type, set_reg);
    }
    var str_lang_list = "";

    function set_reg(lang_list) {
        str_lang_list = lang_list;
        mc_reg_set_form_sdk(str_ctrlchip, str_chip_name, b_chipname_type, str_item_json, get_reg_msg);
    }

    function get_reg_msg() {
        mc_reg_get_item_from_sdk(str_ctrlchip, str_chip_name, b_chipname_type, function (obj_ui_json_res, obj_pamt_merge) {
            if ("object" !== typeof obj_ui_json_res) {
                fun_callback({});
                return;
            }
            var b_update_or_rcstt = mc_reg_judge_ui(str_ui_json, JSON.stringify(obj_ui_json_res));

            obj_ui_json_res = mc_reg_repair_ui_json(obj_ui_json_res);
            obj_ui_json_res = JSON.parse(obj_ui_json_res);
            fun_callback(obj_ui_json_res, obj_pamt_merge, str_lang_list, b_update_or_rcstt);
        });
    }
}

/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *   获取寄存器项
 * 参数:
 *    @param {Promise<string>} str_ctrlchip 控制芯片名称,不能为空
 *    @param {Promise<string>} str_chip_name 传入显示芯片/行管芯片名称
 *    @param {Promise<boolean>} b_chipname_type 传入显示芯片/行管芯片名称标识的布尔值,ture/fase = 显示芯片/行管芯片
 *    @param {Promise<function>} fun_callback 回调函数,不能为空(转换好后的ui_json对象,合并参数表)
 * 返回：
 *    NA
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 徐烁超
 *      时间 : 2019.12.03
 *      内容 : 所有代码
 ************************************************************************************************/
function mc_reg_get_item_from_sdk(str_ctrlchip, str_chip_name, b_chipname_type, fun_callback) {
    if ("function" !== typeof fun_callback) {
        return;
    }
    if ("string" !== typeof str_ctrlchip || 0 >= str_ctrlchip.length) {
        fun_callback();
        return;
    }
    if ("string" !== typeof str_chip_name || 0 >= str_chip_name.length) {
        fun_callback();
        return;
    }
    var str_req_fun = JSON_FUN_SCANCHIP_REG_ITEM;

    if (b_chipname_type) {
        str_req_fun = JSON_FUN_DISPCHIP_REG_ITEM;
    }
    var str_item_json_req = new mc_sdk_param();

    str_item_json_req.set_param_clear();
    str_item_json_req.set_func(str_req_fun);
    str_item_json_req.set_cmd(JSON_PAPRAM_GET);
    str_item_json_req.set_param_value(str_chip_name, "");
    str_item_json_req.set_attr_val(str_chip_name, JSON_ATTR_ID_CTRLCHIP, str_ctrlchip);
    $.post("/access_shell", str_item_json_req.get_json(), function (response, status) {
        if ("success" !== status) {
            fun_callback("");
            return;
        }
        var ary_res = [];
        var obj_sdk_param = new mc_sdk_param();

        obj_sdk_param.set_json(response);
        var str_parma_data = obj_sdk_param.get_param_value(str_chip_name);

        ary_res = mc_reg_tran_item_to_ui(str_parma_data);

        fun_callback(ary_res[0], ary_res[1]);
    }, "text");
}

/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *   设置显示/行管芯片寄存器项
 * 参数:
 *    @param {Promise<string>} str_ctrlchip 控制芯片名称,不能为空
 *    @param {Promise<string>} str_chip_name 传入显示芯片/行管芯片名称
 *    @param {Promise<boolean>} b_chipname_type 传入显示芯片/行管芯片名称标识的布尔值,ture/fase = 显示芯片/行管芯片
 *    @param {Promise<string>} str_ui_json 转换为item_json后的的ui_json字串,不能为空
 *    @param {Promise<function>} fun_callback 回调函数,不能为空
 * 返回：
 *    NA
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 徐烁超
 *      时间 : 2019.12.03
 *      内容 : 所有代码
 ************************************************************************************************/
function mc_reg_set_form_sdk(str_ctrlchip, str_chip_name, b_chipname_type, str_ui_json, fun_callback) {
    if ("function" !== typeof fun_callback) {
        return;
    }
    if ("string" !== typeof str_ctrlchip || 0 >= str_ctrlchip.length) {
        fun_callback();
        return;
    }
    if ("string" !== typeof str_ui_json || 0 >= str_ui_json.length) {
        fun_callback();
        return;
    }
    if ("string" !== typeof str_chip_name || 0 >= str_chip_name.length) {
        fun_callback();
        return;
    }
    var str_req_fun = JSON_FUN_SCANCHIP_REG_ITEM;

    if (b_chipname_type) {
        str_req_fun = JSON_FUN_DISPCHIP_REG_ITEM;
    }
    var str_item_json_req = new mc_sdk_param();

    str_item_json_req.set_param_clear();
    str_item_json_req.set_func(str_req_fun);
    str_item_json_req.set_cmd(JSON_PAPRAM_SET);
    str_item_json_req.set_param_value(str_chip_name, str_ui_json);
    str_item_json_req.set_attr_val(str_chip_name, JSON_ATTR_ID_CTRLCHIP, str_ctrlchip);
    $.post("/access_shell", str_item_json_req.get_json(), function (_response, status) {
        if ("success" !== status) {
            fun_callback();
            return;
        }
        fun_callback();
        return;
    }, "text");
}

/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *   获取寄存器项语言表
 * 参数:
 *    @param {Promise<string>} str_ctrlchip 控制芯片名称,不能为空
 *    @param {Promise<string>} str_chip_name 传入显示芯片/行管芯片名称
 *    @param {Promise<boolean>} b_chipname_type 传入显示芯片/行管芯片名称标识的布尔值,ture/fase = 显示芯片/行管芯片
 *    @param {Promise<function>} fun_callback 回调函数,不能为空(显示/行管芯片寄存器语言表)
 * 返回：
 *    NA
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 徐烁超
 *      时间 : 2019.12.03
 *      内容 : 所有代码
 ************************************************************************************************/

function mc_reg_language_suf(str_ctrlchip, str_chip_name, b_chipname_type, fun_callback) {
    if ("function" !== typeof fun_callback) {
        return;
    }
    if ("string" !== typeof str_ctrlchip || 0 >= str_ctrlchip.length) {
        return;
    }
    if ("string" !== typeof str_chip_name || 0 >= str_chip_name.length) {
        return;
    }
    var str_req_fun = JSON_FUN_SCANCHIP_REG_ITEM_LANG;

    if (b_chipname_type) {
        str_req_fun = JSON_FUN_DISPCHIP_REG_ITEM_LANG;
    }
    var str_item_json_req = new mc_sdk_param();

    str_item_json_req.set_param_clear();
    str_item_json_req.set_func(str_req_fun);
    str_item_json_req.set_cmd(JSON_PAPRAM_GET);
    str_item_json_req.set_param_value(str_chip_name, "");
    str_item_json_req.set_attr_val(str_chip_name, JSON_ATTR_ID_CTRLCHIP, str_ctrlchip);
    $.post("/access_shell", str_item_json_req.get_json(), function (response, status) {
        if ("success" !== status) {
            return;
        }
        var str_item_json_res = new mc_sdk_param();

        str_item_json_res.set_param_clear();
        str_item_json_res.set_json(response);
        var str_lang_json = str_item_json_res.get_param_value(str_chip_name);

        fun_callback(mc_reg_tran_lang_item_to_ui(str_lang_json));
        return;
    }, "text");
}

/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    转换寄存器项为页面字串
 * 参数:
 *    @param {Promise<string>} str_ui_json 传入需要转换的json字串,不能为空
 * 返回：
 *    @returns {Promise<Array>} [转换后的字串,合并参数表]
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 徐烁超
 *      时间 : 2019.12.03
 *      内容 : 所有代码
 ************************************************************************************************/
function mc_reg_tran_item_to_ui(str_ui_json) {
    if ("string" !== typeof str_ui_json || 0 >= str_ui_json) {
        return [];
    }
    var str_item_json_res = new mc_sdk_param();
    var str_common_json = new mc_sdk_param();
    var str_str_json = new mc_sdk_param();
    var obj_pamt_merge_suf = {};
    var ary_req = [];

    str_item_json_res.set_param_clear();
    str_item_json_res.set_json(str_ui_json);
    str_common_json.set_param_clear();
    str_common_json.set_json(str_item_json_res.get_param_value("COMMON"));

    str_str_json.set_param_clear();
    str_str_json.set_json(str_item_json_res.get_param_value("STR"));

    var ary_param_name = [];
    var str_pamay_name = "";
    var ui_param_cnt = str_common_json.get_param_cnt();
    var idx_param = 0;

    for (idx_param = 0; idx_param < ui_param_cnt; idx_param++) {
        str_pamay_name = str_common_json.get_param_name(idx_param);
        ary_param_name.push(str_pamay_name);
    }
    ui_param_cnt = str_str_json.get_param_cnt();
    for (idx_param = 0; idx_param < ui_param_cnt; idx_param++) {
        str_pamay_name = str_str_json.get_param_name(idx_param);
        ary_param_name.push(str_pamay_name);
    }
    var idx_ary_length = ary_param_name.length;
    var ary_idx_param_name = "";

    while (0 < idx_ary_length) {
        for (var idx_ary_param = 0; idx_ary_param < idx_ary_length - 1; idx_ary_param++) {
            if (ary_param_name[idx_ary_param] > ary_param_name[idx_ary_param + 1]) {
                ary_idx_param_name = ary_param_name[idx_ary_param];
                ary_param_name[idx_ary_param] = ary_param_name[idx_ary_param + 1];
                ary_param_name[idx_ary_param + 1] = ary_idx_param_name;
            }
        }
        idx_ary_length--;
    }
    str_item_json_res.set_param_clear();
    var str_attr_name = "";
    var str_attr_val = "";
    var ui_attr_cnt = 0;

    for (var idx_ary_pame = 0; idx_ary_pame < ary_param_name.length; idx_ary_pame++) {
        str_pamay_name = ary_param_name[idx_ary_pame];
        var str_pamay_val = str_common_json.get_param_value(str_pamay_name);

        obj_pamt_merge_suf[str_pamay_name] = true;
        if ("string" !== typeof str_pamay_val || 0 > str_pamay_val.length) {
            str_pamay_val = str_str_json.get_param_value(str_pamay_name);
            obj_pamt_merge_suf[str_pamay_name] = false;
        }
        str_item_json_res.set_param_value(str_pamay_name, str_pamay_val);
        ui_attr_cnt = str_common_json.get_attr_cnt(str_pamay_name);

        if (0 >= ui_attr_cnt) {
            ui_attr_cnt = str_str_json.get_attr_cnt(str_pamay_name);
        }
        for (var idx_attr = 0; idx_attr < ui_attr_cnt; idx_attr++) {
            str_attr_name = str_common_json.get_attr_name(str_pamay_name, idx_attr);
            if ("string" !== typeof str_attr_name || 0 > str_attr_name.length) {
                str_attr_name = str_str_json.get_attr_name(str_pamay_name, idx_attr);
            }
            str_attr_val = str_common_json.get_attr_val(str_pamay_name, str_attr_name);
            if ("string" !== typeof str_attr_val || 0 > str_attr_val.length) {
                str_attr_val = str_str_json.get_attr_val(str_pamay_name, str_attr_name);
            }
            str_item_json_res.set_attr_val(str_pamay_name, str_attr_name, str_attr_val);
        }
    }
    var obj_ui_json = {};

    if (0 < str_item_json_res.get_param_cnt()) {
        obj_ui_json = JSON.parse(str_item_json_res.get_json());
    }
    ary_req.push(obj_ui_json);
    ary_req.push(obj_pamt_merge_suf);
    return ary_req;
}

/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    转换寄存器项为发送字串
 * 参数:
 *    @param {Promise<object>} obj_ui_json 实例好的ui_json对象
 *    @param {Promise<object>} obj_pamt_merge_suf 传入需要合并表,不能为空
 *    @param {Promise<string>} str_end_name 最后一个操作的属性名
 * 返回：
 *    @returns {Promise<string>} 转换为发送模板的item_json
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 徐烁超
 *      时间 : 2019.12.03
 *      内容 : 所有代码
 ************************************************************************************************/
function mc_reg_tran_ui_to_item(obj_ui_json, obj_pamt_merge_suf, str_end_name) {
    if ("object" !== typeof obj_ui_json) {
        return false;
    }
    if ("object" !== typeof obj_pamt_merge_suf) {
        return obj_ui_json.get_json();
    }
    var str_item_json_req = new mc_sdk_param();
    var str_common_json = new mc_sdk_param();
    var str_str_json = new mc_sdk_param();
    var ui_param_cnt = obj_ui_json.get_param_cnt();

    str_item_json_req.set_param_clear();
    str_common_json.set_param_clear();
    str_str_json.set_param_clear();

    for (var idx_param = 0; idx_param < ui_param_cnt; idx_param++) {
        var str_pamay_name = obj_ui_json.get_param_name(idx_param);
        var str_pamay_val = obj_ui_json.get_param_value(str_pamay_name);
        var ui_attr_cnt = obj_ui_json.get_attr_cnt(str_pamay_name);

        if (obj_pamt_merge_suf[str_pamay_name]) {
            str_common_json.set_param_value(str_pamay_name, str_pamay_val);
        }
        str_str_json.set_param_value(str_pamay_name, str_pamay_val);
        for (var idx_attr = 0; idx_attr < ui_attr_cnt; idx_attr++) {
            var str_attr_name = obj_ui_json.get_attr_name(str_pamay_name, idx_attr);
            var str_attr_val = obj_ui_json.get_attr_val(str_pamay_name, str_attr_name);

            if (obj_pamt_merge_suf[str_pamay_name]) {
                str_common_json.set_attr_val(str_pamay_name, str_attr_name, str_attr_val);
            }
            str_str_json.set_attr_val(str_pamay_name, str_attr_name, str_attr_val);
        }
    }
    str_item_json_req.set_param_value("COMMON", str_common_json.get_json());
    str_item_json_req.set_param_value("STR", str_str_json.get_json());
    str_item_json_req.set_param_value("LAST_EDIT_ID", str_end_name);
    return str_item_json_req.get_json();
}
/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    转换语言表
 * 参数:
 *    @param {Promise<string>} str_lang_json 传入需要转换的语言解释表json字串,不能为空
 * 返回：
 *    @returns {Promise<string>} 转换为需要的语言解释表对象
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 徐烁超
 *      时间 : 2019.12.03
 *      内容 : 所有代码
 ************************************************************************************************/
function mc_reg_tran_lang_item_to_ui(str_lang_json) {
    if ("string" !== typeof str_lang_json || 0 >= str_lang_json.length) {
        return "";
    }
    var str_item_json_req = new mc_sdk_param();
    var obj_language = {};

    str_item_json_req.set_param_clear();
    str_item_json_req.set_json(str_lang_json);
    var ui_param_cnt = str_item_json_req.get_param_cnt();
    var str_pamay_val = "";
    var str_pamay_name = "";

    for (var idx_param = 0; idx_param < ui_param_cnt; idx_param++) {
        str_pamay_name = str_item_json_req.get_param_name(idx_param);
        str_pamay_val = str_item_json_req.get_param_value(str_pamay_name);
        obj_language[str_pamay_name] = str_pamay_val;
    }
    return obj_language;
}

/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    修复ui_json
 * 参数:
 *    @param {Promise<Object>} obj_ui_json 传入需要转换的对象,不能为空
 * 返回：
 *    @returns {Promise<String>} 将修复好的ui_json返回
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 徐烁超
 *      时间 : 2019.12.03
 *      内容 : 所有代码
 ************************************************************************************************/
function mc_reg_repair_ui_json(obj_ui_json) {
    if ("object" !== typeof obj_ui_json) {
        return "";
    }
    var str_ui_json_res = new mc_sdk_param();

    str_ui_json_res.set_param_clear();
    str_ui_json_res.set_json(JSON.stringify(obj_ui_json));
    var ui_param_cnt = str_ui_json_res.get_param_cnt();
    var str_pamay_name = "";
    var str_attr_name = JSON_ATTR_ID_UI_TYPE;
    var str_attr_val = "";

    for (var idx_param = 0; idx_param < ui_param_cnt; idx_param++) {
        str_pamay_name = str_ui_json_res.get_param_name(idx_param);
        str_attr_val = str_ui_json_res.get_attr_val(str_pamay_name, str_attr_name);
        var str_add_txt = str_ui_json_res.get_attr_val(str_pamay_name, "ADD_TXT");

        if ("string" === typeof str_add_txt && 0 < str_add_txt.length) {
            str_attr_name = "ARRAY";
            str_ui_json_res.set_attr_val(str_pamay_name, str_attr_name, str_add_txt);
        }

        if ("string" === typeof str_attr_val) {
            str_attr_val = str_attr_val.trim().toLocaleUpperCase();

            if ("function" !== typeof G_ARR_UI_TYPE[str_attr_val] ) {
                str_ui_json_res.set_attr_val(str_pamay_name, str_attr_name, JSON_TYPE_VALUE_EDIT);
            }

            continue;
        }

        str_ui_json_res.set_attr_val(str_pamay_name, str_attr_name, JSON_TYPE_VALUE_EDIT);
    }

    return str_ui_json_res.get_json();
}

/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    判断更新或者创建
 * 参数:
 *    @param {Promise<string>} str_ui_json 传入ui_json字串,不能为空
 *    @param {Promise<string>} str_item_json 传入item_json字串,不能为空
 * 返回：
 *    @returns {Boolean} 返回ture/需要更新--false/需要重建
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 徐烁超
 *      时间 : 2019.12.03
 *      内容 : 所有代码
 ************************************************************************************************/
function mc_reg_judge_ui(str_ui_json, str_item_json) {
    if ("string" !== typeof str_ui_json || 0 >= str_ui_json.length) {
        return false;
    }
    if ("string" !== typeof str_item_json || 0 >= str_item_json.length) {
        return false;
    }
    var str_ui_json_res = new mc_sdk_param();
    var str_item_json_res = new mc_sdk_param();

    str_ui_json_res.set_param_clear();
    str_item_json_res.set_param_clear();
    str_ui_json_res.set_json(str_ui_json);
    str_item_json_res.set_json(str_item_json);
    var ui_param_cnt = str_ui_json_res.get_param_cnt();
    var str_pamay_name = "";

    if (ui_param_cnt !== str_item_json_res.get_param_cnt()) {
        return false;
    }
    for (var idx_param = 0; idx_param < ui_param_cnt; idx_param++) {
        str_pamay_name = str_ui_json_res.get_param_name(idx_param);
        if (str_pamay_name !== str_item_json_res.get_param_name(idx_param)) {
            return false;
        }
    }
    return true;
}

/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    通过下标找到对应值
 * 参数:
 *    @param {Promise<string>} str_array 传入ui_json字串,不能为空
 *    @param {Promise<Number>} idx 查询下标,不能为空
 * 返回：
 *    @returns {Promise<string>} 查询结果
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 徐烁超
 *      时间 : 2019.12.03
 *      内容 : 所有代码
 ************************************************************************************************/
function mc_reg_idx_inquire(str_array, idx) {
    if ("string" !== typeof str_array || 0 >= str_array.length) {
        return "";
    }
    if ("number" !== typeof idx) {
        return "";
    }
    var ary_req = mc_reg_splice_str(str_array, ",");
    var str_val = ary_req[idx];

    if ("string" !== typeof str_val || 0 >= str_val.length) {
        return "";
    }
    str_val = mc_reg_splice_str(str_val, "=", 1);
    return str_val;
}

/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    通过值查找下标
 * 参数:
 *    @param {Promise<string>} str_array 传入ui_json字串,不能为空
 *    @param {Promise<string>} val 查询值,不能为空
 * 返回：
 *    @returns {Promise<Uint>} 查询结果
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 徐烁超
 *      时间 : 2019.12.03
 *      内容 : 所有代码
 ************************************************************************************************/
function mc_reg_val_inquire(str_array, val) {
    if ("string" !== typeof str_array || 0 >= str_array.length) {
        return false;
    }
    if ("string" === typeof val || 0 >= val.length) {
        return false;
    }
    var ary_req = mc_reg_splice_str(str_array, ",");
    var idx_array = 0;

    for (var idx_ary = 0; idx_ary < ary_req.length; idx_ary++) {
        var str_val = ary_req[idx_ary];

        if ("string" !== typeof str_val || 0 >= str_val.length) {
            continue;
        }
        str_val = mc_reg_splice_str(str_val, "=", 1);
        if (str_val === val) {
            idx_array = idx_ary;
            break;
        }
    }
    return idx_array;
}

/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    获取寄存器列表
 * 参数:
 *    @param {Promise<string>} str_ctrlchip 传入控制芯片名称,不能为空
 *    @param {Promise<string>} str_chip_name 传入显示芯片/行管芯片名称
 *    @param {Promise<boolean>} b_chipname_type 传入显示芯片/行管芯片名称标识的布尔值,ture/fase = 显示芯片/行管芯片
 *    @param {Promise<function>} fun_callback 传入回调函数,不能为空(寄存器列表对象)
 * 返回：
 *    NA
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 徐烁超
 *      时间 : 2019.12.03
 *      内容 : 所有代码
 ************************************************************************************************/

function mc_reg_get_list_from_sdk(str_ctrlchip, str_chip_name, b_chipname_type, fun_callback) {
    if ("function" !== typeof fun_callback) {
        return;
    }
    if ("string" !== typeof str_ctrlchip || 0 >= str_ctrlchip.length) {
        fun_callback();
        return;
    }
    if ("string" !== typeof str_chip_name || 0 >= str_chip_name.length) {
        fun_callback();
        return;
    }
    var str_req_fun = JSON_FUN_SCANCHIP_REG_LIST;

    if (b_chipname_type) {
        str_req_fun = JSON_FUN_DISPCHIP_REG_LIST;
    }
    var str_item_json_req = new mc_sdk_param();

    str_item_json_req.set_param_clear();
    str_item_json_req.set_cmd(JSON_PAPRAM_GET);
    str_item_json_req.set_func(str_req_fun);
    str_item_json_req.set_param_value(str_chip_name, "");
    str_item_json_req.set_attr_val(str_chip_name, JSON_ATTR_ID_CTRLCHIP, str_ctrlchip);
    $.post("/access_shell", str_item_json_req.get_json(), function (response, status) {
        if ("success" !== status) {
            return;
        }
        var str_item_json_res = new mc_sdk_param();

        str_item_json_res.set_param_clear();
        str_item_json_res.set_json(response);
        str_item_json_res = str_item_json_res.get_param_value(str_chip_name);
        str_item_json_res = mc_reg_list_tran_item_to_ui(str_item_json_res);
        fun_callback(JSON.parse(str_item_json_res));
        return;
    }, "text");
}

/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    转换寄存器列表,改为ui识别json
 * 参数:
 *      @param {Promise<string>} str_item_json 传入item_json字串,不能为空
 * 返回：
 *    @returns {String} 转换完后的ui_json字串
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 徐烁超
 *      时间 : 2019.12.03
 *      内容 : 所有代码
 ************************************************************************************************/
function mc_reg_list_tran_item_to_ui(str_item_json) {
    if ("string" !== typeof str_item_json || 0 >= str_item_json.length) {
        return "";
    }
    var str_item_json_res = new mc_sdk_param();
    var ary_r = [];
    var ary_g = [];
    var ary_b = [];
    var ary_max = [];

    str_item_json_res.set_param_clear();
    str_item_json_res.set_json(str_item_json);
    ary_r = mc_reg_splice_str(str_item_json_res.get_param_value("REGLIST_R"), ",");
    ary_g = mc_reg_splice_str(str_item_json_res.get_param_value("REGLIST_G"), ",");
    ary_b = mc_reg_splice_str(str_item_json_res.get_param_value("REGLIST_B"), ",");

    str_item_json_res.set_param_clear();
    var ui_param_cnt = ary_r.length;

    if (ui_param_cnt < ary_g.length) {
        ui_param_cnt = ary_g.length;
        ary_max = ary_g;
    } else if (ui_param_cnt < ary_b.length) {
        ui_param_cnt = ary_b.length;
        ary_max = ary_b;
    } else {
        ary_max = ary_r;
    }

    for (var idx_param = 0; idx_param < ui_param_cnt; idx_param++) {
        var str_pamay_name = idx_param + 1;

        str_pamay_name = str_pamay_name.toString();
        if ("string" !== typeof ary_r[idx_param] || 0 >= ary_r[idx_param].length) {
            ary_r[idx_param] = ary_max[idx_param];
        } else if ("string" !== typeof ary_g[idx_param] || 0 >= ary_g[idx_param].length) {
            ary_g[idx_param] = ary_max[idx_param];
        } else if ("string" !== typeof ary_b[idx_param] || 0 >= ary_b[idx_param].length) {
            ary_b[idx_param] = ary_max[idx_param];
        }
        var str_pamay_val = "R=" + ary_r[idx_param] + "," + "G=" + ary_g[idx_param] + "," + "B=" + ary_b[idx_param];

        str_item_json_res.set_param_value(str_pamay_name, str_pamay_val);
        str_item_json_res.set_attr_val(str_pamay_name, JSON_ATTR_ID_UI_TYPE, JSON_TYPE_VALUE_EDIT);
        str_item_json_res.set_attr_val(str_pamay_name, JSON_ATTR_ID_VAL_TYPE, JSON_TYPE_VALUE_HEX);
    }
    return str_item_json_res.get_json();
}


/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    寄存器列表更新
 * 参数:
 *    @param {Promise<string>} str_ctrlchip 传入控制芯片名称,不能为空
 *    @param {Promise<string>} str_chip_name 传入显示芯片/行管芯片名称
 *    @param {Promise<boolean>} b_chipname_type 传入显示芯片/行管芯片名称标识的布尔值,ture/fase = 显示芯片/行管芯片
 *    @param {Promise<object>} obj_ui_json_from_ui 来自页面的ui_json对象
 *    @param {Promise<function>} fun_callback 传入回调函数,不能为空(寄存器列表对象,是否更新布尔值)
 *    @param {Promise<Boolean>} b_is_default 获取常规模式
 * 返回：
 *    NA
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 徐烁超
 *      时间 : 2019.12.03
 *      内容 : 所有代码
 ************************************************************************************************/
function mc_reg_update_list_from_sdk(str_ctrlchip, str_chip_name, b_chipname_type, obj_ui_json_from_ui, fun_callback, b_is_default) {
    if ("function" !== typeof fun_callback) {
        return;
    }
    if ("string" !== typeof str_ctrlchip || 0 >= str_ctrlchip.length) {
        fun_callback("");
        return;
    }
    if ("string" !== typeof str_chip_name || 0 >= str_chip_name.length) {
        fun_callback("");
        return;
    }
    var str_ui_json = JSON.stringify(obj_ui_json_from_ui);

    str_ui_json = mc_reg_list_trans_ui_to_item(str_ui_json);
    if (b_is_default) {
        mc_reg_get_list_from_sdk(str_ctrlchip, str_chip_name, b_chipname_type, function (obj_ui_json_from_item) {
            var str_item_json = JSON.stringify(obj_ui_json_from_item);

            var b_update_or_rcstt = mc_reg_judge_ui(str_ui_json, str_item_json);

            fun_callback(obj_ui_json_from_item, b_update_or_rcstt);
            return;
        });
    } else {
        mc_reg_set_list_from_sdk(str_ctrlchip, str_chip_name, b_chipname_type, str_ui_json, function () {
            mc_reg_get_list_from_sdk(str_ctrlchip, str_chip_name, b_chipname_type, function (obj_ui_json_from_item) {
                var str_item_json = JSON.stringify(obj_ui_json_from_item);

                var b_update_or_rcstt = mc_reg_judge_ui(str_ui_json, str_item_json);

                fun_callback(obj_ui_json_from_item, b_update_or_rcstt);
                return;
            });
        });
    }
}

/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    设置寄存器列表
 * 参数:
 *    @param {Promise<string>} str_ctrlchip 控制芯片名称,不能为空
 *    @param {Promise<string>} str_chip_name 传入显示芯片/行管芯片名称
 *    @param {Promise<boolean>} b_chipname_type 传入显示芯片/行管芯片名称标识的布尔值,ture/fase = 显示芯片/行管芯片
 *    @param {Promise<string>} str_ui_json ui_json字串,不能为空
 *    @param {Promise<function>} fun_callback 回调函数,不能为空
 * 返回：
 *    NA
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 徐烁超
 *      时间 : 2019.12.03
 *      内容 : 所有代码
 ************************************************************************************************/
function mc_reg_set_list_from_sdk(str_ctrlchip, str_chip_name, b_chipname_type, str_ui_json, fun_callback) {
    if ("function" !== typeof fun_callback) {
        return;
    }
    if ("string" !== typeof str_ctrlchip || 0 >= str_ctrlchip.length) {
        fun_callback();
        return;
    }
    if ("string" !== typeof str_ui_json || 0 >= str_ui_json.length) {
        fun_callback();
        return;
    }
    if ("string" !== typeof str_chip_name || 0 >= str_chip_name.length) {
        fun_callback();
        return;
    }
    var str_req_fun = JSON_FUN_SCANCHIP_REG_LIST;

    if (b_chipname_type) {
        str_req_fun = JSON_FUN_DISPCHIP_REG_LIST;
    }
    var str_ui_json_req = new mc_sdk_param();

    str_ui_json_req.set_param_clear();
    str_ui_json_req.set_cmd(JSON_PAPRAM_SET);
    str_ui_json_req.set_func(str_req_fun);
    str_ui_json_req.set_param_value(str_chip_name, str_ui_json);
    str_ui_json_req.set_attr_val(str_chip_name, JSON_ATTR_ID_CTRLCHIP, str_ctrlchip);
    $.post("/access_shell", str_ui_json_req.get_json(), function (_response, status) {
        if ("success" !== status) {
            return;
        }
        fun_callback();
        return;
    }, "text");
}

/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    转换寄存器列表为发送寄存器列表字串
 * 参数:
 *    @param {Promise<string>} str_ui_json ui_json字串,不能为空
 * 返回：
 *    @returns {Promise<String>} 转换为可发送设置请求的item_json字串
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 徐烁超
 *      时间 : 2019.12.03
 *      内容 : 所有代码
 ************************************************************************************************/
function mc_reg_list_trans_ui_to_item(str_ui_json) {
    if ("string" !== typeof str_ui_json || 0 >= str_ui_json.length) {
        return "";
    }
    var str_ui_json_req = new mc_sdk_param();
    var str_ui_json_res = new mc_sdk_param();

    str_ui_json_req.set_param_clear();
    str_ui_json_res.set_param_clear();
    str_ui_json_req.set_json(str_ui_json);
    var ui_param_cnt = str_ui_json_req.get_param_cnt();

    if (0 >= ui_param_cnt) {
        return false;
    }
    var str_r = "";
    var str_g = "";
    var str_b = "";

    for (var idx_param = 0; idx_param < ui_param_cnt; idx_param++) {
        var str_pamay_name = str_ui_json_req.get_param_name(idx_param);
        var str_pamay_val = str_ui_json_req.get_param_value(str_pamay_name);
        var ary_pamay_val = mc_reg_splice_str(str_pamay_val, ",");

        str_r += mc_reg_splice_str(ary_pamay_val[0], "=", 1) + ",";
        str_g += mc_reg_splice_str(ary_pamay_val[1], "=", 1) + ",";
        str_b += mc_reg_splice_str(ary_pamay_val[2], "=", 1) + ",";
    }
    str_r = str_r.substr(0, str_r.length - 1);
    str_g = str_g.substr(0, str_g.length - 1);
    str_b = str_b.substr(0, str_b.length - 1);

    str_ui_json_res.set_param_value("REGLIST_B", str_b);
    str_ui_json_res.set_param_value("REGLIST_G", str_g);
    str_ui_json_res.set_param_value("REGLIST_R", str_r);

    return str_ui_json_res.get_json();
}

/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    应用当前寄存器
 * 参数:
 *    @param {Promise<object>} obj_box_data 当前箱体数据
 *    @param {Promise<Function>} fn_callblack 设置完成回调
 * 返回：
 *    NA
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 徐烁超
 *      时间 : 2019.12.03
 *      内容 : 所有代码
 ************************************************************************************************/
function mc_reg_set_reg_for_box_data(obj_box_data, fn_callblack) {
    var obj_rec_data = obj_box_data.data;
    var str_dischip_reg_old = obj_rec_data.mc_util_get_disp_reg().get_json();
    var str_scanchip_reg_old = obj_rec_data.mc_util_get_scan_reg().get_json();
    var str_dischip_list_old = obj_rec_data.mc_util_get_disp_reg_list().get_json();
    var str_scanchip_list_old = obj_rec_data.mc_util_get_scan_reg_list().get_json();

    mc_sdk_get_reg(g_str_ctrlchip, g_str_dispchip, true, function (str_disp_reg_item) {
        var obj_sdk_reg_disp = new mc_sdk_param();

        obj_sdk_reg_disp.set_json(str_disp_reg_item);
        str_disp_reg_item = obj_sdk_reg_disp.get_param_value(g_str_dispchip);
        obj_sdk_reg_disp.set_json(str_disp_reg_item);

        obj_rec_data.mc_util_set_disp_reg(obj_sdk_reg_disp);
        mc_sdk_get_reg(g_str_ctrlchip, g_str_scanchip, false, function (str_scan_reg_item) {
            var obj_sdk_reg_scan = new mc_sdk_param();

            obj_sdk_reg_scan.set_json(str_scan_reg_item);
            str_scan_reg_item = obj_sdk_reg_scan.get_param_value(g_str_scanchip);
            obj_sdk_reg_scan.set_json(str_scan_reg_item);
            obj_rec_data.mc_util_set_scan_reg(obj_sdk_reg_scan);
            mc_sdk_get_reg_list(g_str_ctrlchip, g_str_dispchip, true, function (str_disp_reg_list) {
                var obj_sdk_reg_disp_list = new mc_sdk_param();

                obj_sdk_reg_disp_list.set_json(str_disp_reg_list);
                str_disp_reg_list = obj_sdk_reg_disp_list.get_param_value(g_str_dispchip);
                obj_sdk_reg_disp_list.set_json(str_disp_reg_list);
                obj_rec_data.mc_util_set_disp_reg_list(obj_sdk_reg_disp_list);
                mc_sdk_get_reg_list(g_str_ctrlchip, g_str_scanchip, false, function (str_scan_reg_list) {
                    var obj_sdk_reg_scan_list = new mc_sdk_param();

                    obj_sdk_reg_scan_list.set_json(str_scan_reg_list);
                    str_scan_reg_list = obj_sdk_reg_scan_list.get_param_value(g_str_scanchip);
                    obj_sdk_reg_scan_list.set_json(str_scan_reg_list);
                    obj_rec_data.mc_util_set_scan_reg_list(obj_sdk_reg_scan_list);
                    var str_box_md5 = mc_crypto_set_box_md5_to_key(obj_box_data);
                    var ary_box_data = parent.ARY_BOX_DATA;

                    for (var idx_box = 0; idx_box < ary_box_data.length; idx_box++) {
                        var obj_box_data_loc = ary_box_data[idx_box];
                        var str_box_name_loc = obj_box_data_loc.name;
                        var str_box_md5_loc = mc_crypto_set_box_md5_to_key(obj_box_data_loc);

                        if (str_box_name_loc === g_str_box_name) {
                            continue;
                        }
                        if (str_box_md5_loc === str_box_md5) {
                            obj_box_data.data.mc_util_get_disp_reg().set_json(str_dischip_reg_old);
                            obj_box_data.data.mc_util_get_scan_reg().set_json(str_scanchip_reg_old);
                            obj_box_data.data.mc_util_get_disp_reg_list().set_json(str_dischip_list_old);
                            obj_box_data.data.mc_util_get_scan_reg_list().set_json(str_scanchip_list_old);
                            g_str_merge_box_name = str_box_name_loc;
                            mc_get_top_fun("mc_confirm_popout", {
                                msg: "MC_LANG_BOX_PARAM_EXIT",
                                btn: ["MC_LANG_MERGE", "MC_LANG_RETURN"],
                                confirm_callback: "mc_reg_merge_box"
                            });
                            return;
                        }
                    }
                    fn_callblack();
                });
            });
        });
    });
    return;
}


/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    合并箱体
 * 参数:
 *    NA
 * 返回：
 *    NA
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 徐烁超
 *      时间 : 2020.9.17
 *      内容 : 所有代码
 ************************************************************************************************/
function mc_reg_merge_box() {
    var ary_box_data = parent.ARY_BOX_DATA;
    var ary_screen_data = parent.ARY_SCREEN_DATA;
    var ui_box_idx = mc_main_get_idx_by_name(ary_box_data, g_str_box_name);
    var ui_merge_box_idx = mc_main_get_idx_by_name(ary_box_data, g_str_merge_box_name);

    parent.mc_delete_side_btn(ui_box_idx, "box");
    ui_merge_box_idx = mc_main_get_idx_by_name(ary_box_data, g_str_merge_box_name);

    parent.mc_select_side_btn(ui_merge_box_idx, "box");
    for (var idx_screen = 0; idx_screen < ary_screen_data.length; idx_screen++) {
        var ary_send_data = ary_screen_data[idx_screen].data;

        mc_main_updata_screen_data_box_name(ary_send_data, g_str_box_name, g_str_merge_box_name);
    }
    parent.SELECT_BOX_NAME = g_str_merge_box_name;
}

/********** EXPORT API *********************************************************************************/

/* exported mc_reg_get_item_from_sdk_ui_json */
/* exported mc_reg_update_ui_json_from_sdk */
/* exported mc_reg_idx_inquire_to_array */
/* exported mc_reg_val_inquire_to_array */
/* exported mc_reg_get_list_from_sdk_ui_json */
/* exported mc_reg_update_list_from_sdk_ui_json */
/* exported mc_reg_get_uibox_param_json */
/* exported mc_reg_apply_data */
/* exported mc_reg_get_data_in_name */
/* exported mc_reg_language_suf */
/* exported mc_reg_set_param_item */
/* exported mc_reg_set_param_list */
/* exported mc_reg_send_test_data */

/**
 * @param {Promise<Object>} obj_reg_data 寄存器项数据
 * @param {Promise<Function>} fun_callback 回调函数
 * @param {Promise<Boolean>} b_is_default 是否默认
 * @returns {Function} 寄存器项更新
 */
function mc_reg_update_ui_json_from_sdk(obj_reg_data, fun_callback, b_is_default) {
    if ("function" !== typeof fun_callback) {
        return "";
    }
    return mc_reg_update_from_sdk(obj_reg_data, fun_callback, b_is_default);
}

/**
 * @param {Promise<String>} str_array 查找字符串
 * @param {Promise<Number>} idx 查找下标
 * @returns {Function} 通过下标获取值
 */
function mc_reg_idx_inquire_to_array(str_array, idx) {
    if ("string" !== typeof str_array || 0 >= str_array.length) {
        return "";
    }
    if ("number" !== typeof idx) {
        return "";
    }
    return mc_reg_idx_inquire(str_array, idx);
}

//通过值获取下标
/**
 * @param {Promise<String>} str_array 查找字符串
 * @param {Promise<String>} val 查找字符
 * @returns {Function} 通过值获取下标
 */
function mc_reg_val_inquire_to_array(str_array, val) {
    if ("string" !== typeof str_array || 0 >= str_array.length) {
        return "";
    }
    if ("string" !== typeof val || 0 >= val.length) {
        return "";
    }
    return mc_reg_val_inquire(str_array, val);
}

//更新寄存器列表
/**
 * @param {String} str_ctrlchip 主控芯片
 * @param {String} str_chip_name 芯片名称
 * @param {Boolean} b_chipname_type 芯片类型
 * @param {Object} obj_ui_json 数据
 * @param {Function} fun_callback 回调函数
 * @returns {Function} 更新寄存器列表
 */
function mc_reg_update_list_from_sdk_ui_json(str_ctrlchip, str_chip_name, b_chipname_type, obj_ui_json, fun_callback) {
    if ("function" !== typeof fun_callback) {
        return "";
    }
    return mc_reg_update_list_from_sdk(str_ctrlchip, str_chip_name, b_chipname_type, obj_ui_json, fun_callback);
}

/**
 * @param {Object} obj_box_data 储存箱体对象
 * @param {function} fn_callback 完成回调
 * @returns {Function} 应用当前寄存器
 */
function mc_reg_apply_data(obj_box_data, fn_callback) {
    return mc_reg_set_reg_for_box_data(obj_box_data, fn_callback);
}

/**
 * @param {Array} ary_data 查找数组
 * @param {String} data_name 数组中每个对象中的name属性名称
 * @returns {Function} 获取对应箱体名称的箱体下标
 */
function mc_reg_get_data_in_name(ary_data, data_name) {
    if (!Array.isArray(ary_data) || 0 >= ary_data.length) {
        return false;
    }
    if ("undefined" === typeof data_name) {
        return false;
    }
    for (var idx = 0; idx < ary_data.length; idx++) {
        if (ary_data[idx].name === data_name) {
            return ary_data[idx];
        }
    }
    return false;
}
/**
 * @param {Function} fn_callback 设置页面寄存器项至SDK 完成回调
 */
function mc_reg_set_param_item(fn_callback) {
    if ("function" !== typeof fn_callback) {
        return;
    }
    var str_item_json = "";
    var obj_req_sdk_param = new mc_sdk_param();

    obj_req_sdk_param.set_json(g_str_dischip_data);

    str_item_json = mc_reg_tran_ui_to_item(obj_req_sdk_param, g_obj_dischip_data_merge, g_str_dischip_end);
    mc_reg_set_form_sdk(g_str_ctrlchip, g_str_dispchip, true, str_item_json, function () {
        obj_req_sdk_param.set_json(g_str_scanchip_data);
        str_item_json = mc_reg_tran_ui_to_item(obj_req_sdk_param, g_obj_scanchip_data_merge, g_str_scanchip_end);
        mc_reg_set_form_sdk(g_str_ctrlchip, g_str_scanchip, false, str_item_json, function () {
            fn_callback();
        });
    });
}
/**
 * @param {Function} fn_callback 设置页面寄存器列表至SDK 完成回调
 */
function mc_reg_set_param_list(fn_callback) {
    var str_item_json = "";

    str_item_json = mc_reg_list_trans_ui_to_item(g_str_dischip_data_advance);
    mc_reg_set_list_from_sdk(g_str_ctrlchip, g_str_dispchip, true, str_item_json, function () {
        str_item_json = mc_reg_list_trans_ui_to_item(g_str_scanchip_data_advance);
        mc_reg_set_list_from_sdk(g_str_ctrlchip, g_str_scanchip, false, str_item_json, function () {
            fn_callback();
        });
    });
}

/**
 * @param {String} str_order_val 发送命令
 * @param {Array} ary_box_data 箱体链接数据
 * @param {Array} ary_mod_data 模组数据
 * @param {Function} fn_callback 回调函数
 */
function mc_reg_send_test_data(str_order_val, ary_box_data, ary_mod_data, fn_callback) {
    // 创建测试箱体数据
    var str_box_name = parent.SELECT_BOX_NAME;
    var obj_box_data = mc_reg_get_data_in_name(ary_box_data, str_box_name);
    var obj_test_ui_box = new mc_ui_box();
    var obj_test_box_data = {
        name: obj_box_data.name,
        ctrlchip_hub_msg: obj_box_data.ctrlchip_hub_msg,
        data: obj_test_ui_box
    };

    obj_test_ui_box.mc_util_set_gamma_val(obj_box_data.data.mc_util_get_gamma_val());
    obj_test_ui_box.mc_util_set_param(obj_box_data.data.mc_util_get_param());
    obj_test_ui_box.mc_util_set_resul(obj_box_data.data.mc_util_get_resul());
    obj_test_ui_box.mc_util_set_disp_reg(obj_box_data.data.mc_util_get_disp_reg());
    obj_test_ui_box.mc_util_set_disp_reg_list(obj_box_data.data.mc_util_get_disp_reg_list());
    obj_test_ui_box.mc_util_set_scan_reg(obj_box_data.data.mc_util_get_scan_reg());
    obj_test_ui_box.mc_util_set_scan_reg_list(obj_box_data.data.mc_util_get_scan_reg_list());
    obj_test_ui_box.mc_util_set_ui_box_msg(obj_box_data.data.mc_util_get_ui_box_msg());
    obj_test_ui_box.mc_util_set_device_data(obj_box_data.data.mc_util_get_device_data());

    var ary_test_box = [obj_test_box_data];

    var obj_sdk_param = new mc_sdk_param();

    obj_sdk_param.set_json(g_str_dischip_data);
    ary_test_box[0].data.mc_util_get_disp_reg().set_json(mc_reg_tran_ui_to_item(obj_sdk_param, g_obj_dischip_data_merge, g_str_dischip_end));
    obj_sdk_param.set_json(g_str_scanchip_data);
    ary_test_box[0].data.mc_util_get_scan_reg().set_json(mc_reg_tran_ui_to_item(obj_sdk_param, g_obj_scanchip_data_merge, g_str_scanchip_end));
    ary_test_box[0].data.mc_util_get_disp_reg_list().set_json(mc_reg_list_trans_ui_to_item(g_str_dischip_data_advance));
    ary_test_box[0].data.mc_util_get_scan_reg_list().set_json(mc_reg_list_trans_ui_to_item(g_str_scanchip_data_advance));

    // 设置页面寄存器项数据
    mc_reg_set_param_item(function () {
        // 设置页面寄存器列表数据
        mc_reg_set_param_list(function () {
            var str_workmode = "0";

            if (parent.b_if_mass) {
                str_workmode = "1";
            }

            mc_main_send_place(str_box_name, ary_test_box, ary_mod_data, false, "all", str_order_val, parent.g_str_trans_ctrl, true, function () {
                if ("function" === typeof fn_callback) {
                    // parent.mc_alert_popout("MC_LANG_SNED_SUCCESS", "", true);
                    fn_callback();
                } else {
                    parent.layer.close(parent.layer.getFrameIndex(window.name));
                    parent.mc_loading_wait_remove();
                    parent.mc_alert_popout("MC_LANG_SNED_SUCCESS", "", true);
                }
            }, false, true, str_workmode);
        });
    });
}

/**
 * @param {String} str_mod_name 模组名称
 * @param {Array} arr_mod 模组xml
 * @param {Function} fun_callback 回调函数
 */
function mc_set_mod(str_mod_name, arr_mod, fun_callback) {
    var obj_sdk_param = new mc_sdk_param();
    var str_mod_xml = "";

    for (var idx = 0; idx < arr_mod.length; idx++) {
        var str_mod_name_each = arr_mod[idx].name;

        if (str_mod_name_each === str_mod_name) {
            str_mod_xml = arr_mod[idx].data.mc_util_mod_get_xml();
            break;
        }
    }

    obj_sdk_param.set_param_clear();
    obj_sdk_param.set_func("MOD_FILE");
    obj_sdk_param.set_cmd("SET_PARAM");
    obj_sdk_param.set_param_value(str_mod_name, str_mod_xml);
    obj_sdk_param.set_attr_val(str_mod_name, "FILE_OPT", "SET");

    $.post("/access_shell", obj_sdk_param.get_json(), function (response, status) {
        fun_callback();
        return;
    });
    return;
}

/**
 * @param {String} str_chip_name 箱体名称
 * @param {String} str_box_name 箱体名称
 * @param {Function} fun_callback 回调函数
 */
function me_get_dispchip_access(str_chip_name, str_box_name, fun_callback) {
    var str_req = new mc_sdk_param();

    str_req.set_param_clear();
    str_req.set_cmd("GET_PARAM");
    str_req.set_func("DISPCHIP_ACCESS");
    str_req.set_param_value(str_chip_name, "");
    str_req.set_attr_val(str_chip_name, "BOX_FILE", str_box_name);

    $.post("/access_shell", str_req.get_json(), function (result, status) {
        if ("success" !== status) {
            fun_callback("");
            return;
        }


        fun_callback();

        return;
    });
}
